<?php

namespace Drupal\author_field\ProxyClass;

use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Extension\ModuleUninstallValidatorInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Module uninstall validator proxy service class.
 *
 * An author field module uninstall validator enables
 * the lazy load for the service container.
 */
class AuthorFieldUninstallValidator implements ModuleUninstallValidatorInterface {
  use DependencySerializationTrait;

  /**
   * The proxy service.
   *
   * @var string
   */
  protected $drupalProxyService;

  /**
   * The lazy loaded proxy service.
   *
   * @var \Drupal\author_field\AuthorFieldUninstallValidator
   */
  protected $service;

  /**
   * The service container.
   */
  protected ContainerInterface $container;

  /**
   * Constructs a ProxyClass Drupal proxy object.
   */
  public function __construct(ContainerInterface $container, $drupal_proxy_service) {
    $this->container = $container;
    $this->drupalProxyService = $drupal_proxy_service;
  }

  /**
   * Lazy loads the service from the container.
   *
   * @return \Drupal\author_field\AuthorFieldUninstallValidator|object|null
   *   Returns the constructed service.
   */
  protected function lazyLoad() {
    if (!isset($this->service)) {
      $this->service = $this->container->get($this->drupalProxyService);
    }

    return $this->service;
  }

  /**
   * Load "validate" function from the service container.
   *
   * @param string $module
   *   The module.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   */
  public function validate($module): array {
    return $this->lazyLoad()->validate($module);
  }

  /**
   * Sets the string translation service to use.
   */
  public function setStringTranslation(TranslationInterface $translation) {
    return $this->lazyLoad()->setStringTranslation($translation);
  }

}
