CONTENTS OF THIS FILE
---------------------

* Introduction
* Requirements
* Installation
* Configuration
* Drush
* Tips

INTRODUCTION
------------

Auto Libraries Version is a lightweight Drupal module that automates versioning for your
libraries. Instead of hard-coding a version in your *.libraries.yml files, you can set
`version: AUTO_VERSION`. When enabled, the module replaces `AUTO_VERSION` at runtime with
a single, centrally configured value (for example, 1.2.3, a Git tag, or a commit SHA).

This version string is appended to generated asset URLs, providing reliable cache-busting
for CSS and JavaScript across themes and custom modules without repeatedly editing your
code. You can control the behavior and the version value from the Drupal UI or via Drush,
which makes it ideal for CI/CD pipelines where you want each deployment to expose a
consistent, traceable asset version.

The module has no external dependencies and is safe to use in all environments, from
local development to production.

REQUIREMENTS
------------

None.

INSTALLATION
------------

Install as you would normally install a contributed Drupal module. Visit:
https://www.drupal.org/docs/extending-drupal/installing-modules for
further information.

CONFIGURATION
-------------

* Add AUTO_VERSION in your libraries files for each libraries you want be to auto versioned.

```
global-styling:
  version: AUTO_VERSION
  css:
    theme:
      css/theme.css: {}
```

* Customize the module settings in Administration » Configuration » Development
  » Performance » » Auto Libraries Version.

* Enable the auto versioning of libraries Administration » Configuration
  » Development » Performance » Auto Libraries Version.

DRUSH
-----

* Enable the auto versioning of libraries:

  drush cset auto_libraries_version.settings enabled true

* Disable the auto versioning of libraries:

  drush cset auto_libraries_version.settings enabled false

* Set Version of Libraries:

  drush cset auto_libraries_version.settings version x.x.x

TIPS
-----

You can also automatically set the version in your CD, Pipelines or Github Actions.

For example your latest tag or your commit SHA.
