<?php

namespace Drupal\auto_libraries_version\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Auto Libraries Version settings for this site.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'auto_libraries_version_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('auto_libraries_version.settings');
    $form['global'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Global Options'),
    ];
    $form['global']['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Auto Libraries Versioning'),
      '#default_value' => $config->get('enabled'),
      '#description' => $this->t('Check this box to enable Auto Libraries Versioning.'),
    ];

    $form['version'] = [
      '#type' => 'details',
      '#open' => TRUE,
      '#title' => $this->t('Version'),
      '#description' => $this->t('Auto Libraries Version'),
    ];

    $form['version']['version'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Libraries Version'),
      '#default_value' => $config->get('version'),
      '#description' => $this->t('Set the version of the libraries.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    /** @var \Drupal\Core\Config\Config $config */
    $config = $this->config('auto_libraries_version.settings');

    $config
      ->set('enabled', $form_state->getValue('enabled'))
      ->set('version', $form_state->getValue('version'))
      ->save();

    // Clear all caches.
    drupal_flush_all_caches();

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['auto_libraries_version.settings'];
  }

}
