<?php

declare(strict_types=1);

namespace Drupal\auto_node_translate_deepl\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Configure Auto Node Translate Libre settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'auto_node_translate_deepl_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['auto_node_translate_deepl.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('auto_node_translate_deepl.settings');
    $form['apikey'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Api Key'),
      '#description' => $this->t('The Deepl api key'),
      '#maxlength' => 256,
      '#size' => 128,
      '#default_value' => $config->get('apikey'),
      '#required' => TRUE,
    ];
    $form['glossary_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Glossary id'),
      '#description' => $this->t('Leave empty for no glossary'),
      '#default_value' => $config->get('glossary_id'),
    ];
    $language_mapping_form = Url::fromRoute('auto_node_translate_deepl.mapping')->toString();
    $form['info'] = [
      '#markup' => $this->t('<strong>Configure the language mappings <a href="@url">here</a>', ['@url' => $language_mapping_form]),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $config = $this->config('auto_node_translate_deepl.settings');
    $config->set('apikey', $form_state->getValue('apikey'))
      ->set('glossary_id', $form_state->getValue('glossary_id'))
      ->save();
  }

}
