<?php

namespace Drupal\simple_alt_text\Form;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InvokeCommand;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides functionality for autoalt.
 */
class AutoaltGenerator {

  /**
   * AJAX callback to generate alt text.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   *
   * @return \Drupal\Core\Ajax\AjaxResponse
   *   The AJAX response.
   */
  public static function generateAltText(array &$form, FormStateInterface $form_state) {
    $response = new AjaxResponse();
    
    $placeholder_text = 'Generated alt text placeholder - ' . date('Y-m-d H:i:s');
    
    $response->addCommand(new InvokeCommand('input[name="field_image[0][alt]"]', 'val', [$placeholder_text]));
    
    return $response;
  }

} 