# Autocomplete Extras

**Autocomplete Extras** is a lightweight Drupal module that enhances the default
autocomplete widget by adding per-instance configurability for key behavior
parameters:

- **Minimum input length**: Define how many characters a user must type before
triggering the autocomplete Ajax query.
- **Match limit**: Set the maximum number of results displayed in the
autocomplete dropdown.

These settings allow site builders and developers to fine-tune autocomplete
behavior for different use cases—improving performance and user experience where
needed.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/autocomplete_extras).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/autocomplete_extras).


## Features

- Works with core autocomplete widgets.
- Configuration is set at the form element level.
- Can also be configured for the Menu Link content type.


## Use Case Examples

- Require 3 characters before triggering suggestions for large datasets.
- Lift the default 10-result limit to allow users to browse a broader set of
matches when searching large content collections.


## Requirements

This module requires no modules outside of Drupal core 10.3+.


## Installation

Install as you would normally install a contributed Drupal module.
For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

- Enable the module at Administration > Extend.
- Select the "Select number widget" in your field form display configuration.


## Similar modules

- None found.


## Maintainers

- Frank Mably - [mably](https://www.drupal.org/u/mably)
