(($, Drupal, drupalSettings, once) => {
  Drupal.behaviors.autocompleteExtras = {
    attach(context) {
      once('autocomplete-extras', 'input.form-autocomplete', context).forEach(
        (element) => {
          const $autocomplete = $(element);
          const minLength = $autocomplete.data('min-length');
          if (Number(minLength) > 0) {
            $autocomplete.autocomplete('option', 'minLength', minLength);
          }
        },
      );
    },
  };
})(jQuery, Drupal, drupalSettings, once);
