<?php

namespace Drupal\autologout_alterable\Events;

use Drupal\autologout_alterable\Utility\AutologoutProfileInterface;
use Drupal\Core\Session\AccountInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event for autologout profile alteration.
 */
class AutologoutCronProfileAlterEvent extends Event {

  /**
   * Constructs a new AutologoutCronProfileAlterEvent object.
   *
   * @param \Drupal\autologout_alterable\Utility\AutologoutProfileInterface $autologoutProfile
   *   The autologout profile.
   * @param \Drupal\Core\Session\AccountInterface $currentUser
   *   The current user.
   * @param bool $preventSessionDelete
   *   Whether to prevent session deletion.
   */
  public function __construct(
    protected AutologoutProfileInterface $autologoutProfile,
    protected AccountInterface $currentUser,
    protected bool $preventSessionDelete = FALSE,
  ) {}

  /**
   * Get the autologout profile.
   *
   * @return \Drupal\autologout_alterable\Utility\AutologoutProfileInterface
   *   The autologout profile.
   */
  public function getAutologoutProfile(): AutologoutProfileInterface {
    return $this->autologoutProfile;
  }

  /**
   * Set the autologout profile.
   *
   * @param \Drupal\autologout_alterable\Utility\AutologoutProfileInterface $autologoutProfile
   *   The autologout profile.
   */
  public function setAutologoutProfile(AutologoutProfileInterface $autologoutProfile): self {
    $this->autologoutProfile = $autologoutProfile;
    return $this;
  }

  /**
   * Get the current user.
   *
   * @return \Drupal\Core\Session\AccountInterface
   *   The current user.
   */
  public function getCurrentUser(): AccountInterface {
    return $this->currentUser;
  }

  /**
   * Check whether to prevent session deletion.
   *
   * @return bool
   *   Whether to prevent session deletion.
   */
  public function preventSessionDelete(): bool {
    return $this->preventSessionDelete;
  }

  /**
   * Set whether to prevent session deletion.
   *
   * @param bool $preventSessionDelete
   *   Whether to prevent session deletion.
   *
   * @return $this
   *   Return self.
   */
  public function setPreventSessionDelete(bool $preventSessionDelete): self {
    $this->preventSessionDelete = $preventSessionDelete;
    return $this;
  }

}
