# Automated Testing Kit for Drupal

Automated Testing Kit (ATK) is a suite of tests and useful functions for end-to-end
testing using Cypress and Playwright. Below are some tests that are included:

- basic login/logout via the UI
- registration/forget password
- contact us form
- 404, 403 tests
- Entity creation, update and deletion tests (node, media, taxonomy, user)
- sitemap
- caching
- menus
- search
- and more.

New in 2.1:
- FedRAMP tests (see the documentation)

In addition, Automated Testing Kit also provides:
- integration with the QA Accounts module.
- executing Drush commands against target sites via aliases and SSH.
- executing Drush commands against Pantheon via Terminus.
- pre-flight tests to check if the site is ready for testing.

Automated Testing Kit works in the following environments:
- on the native OS (i.e. macOS/Linux)
- native OS against the app in a container (via DDEV/Lando/Docksal)
- within a container.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/automated_testing_kit).

Installation/configuration instructions plus the lists of functions and tests are in
the documentation
[here](https://performantlabs.com/automated-testing-kit/introduction).

Join the Drupal [Slack workspace](https://www.drupal.org/join-slack) and
the [#automated_testing_kit](https://drupal.slack.com/archives/C05DSFVJMD1) channel to ask questions.

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/automated_testing_kit).

Try the Kit first with the [Demo Recipe](https://performantlabs.com/automated-testing-kit/applying-automated-testing-kit-recipe).

To make it easy for develoeprs, testers and staging environments to have their
own, unique snapshots, check out Testor, the [snapshot management  tool](https://github.com/performantlabs/testor).

## Table of contents

- [Requirements](#requirements)
- [Recommended modules](#recommended-modules)
- [Installation](#installation)
- [Configuration](#configuration)
- [FAQ](#faq)
- [Maintainers](#maintainers)


## Requirements

Install on Drupal >=11 and less than 12.

This module requires Cypress or Playwright to be installed plus the browsers you
will test on.

It has several dependencies, which are listed in [the documentation](https://performantlabs.com/automated-testing-kit/requirements).


## Recommended modules

Some tests require additional modules to be installed depending on which tests you want to run.
If you don't want to use those tests, comment them out and don't install the module dependencies.
See [the documentation](https://performantlabs.com/automated-testing-kit/installation) for the modules that the tests require.


## Installation

 * Install as you would normally install a contributed Drupal module. Visit
   https://www.drupal.org/node/1897420 for further information.
 * Installing the module without Composer is not recommended and is unsupported.
 * Thoroughly read [the ATK documentation](https://performantlabs.com/automated-testing-kit/installation). Move the tests to your project
   with the atk_setup script, set up the target URL and further customize the Kit for
   your Drupal installation.


## Configuration

For whichever test framework you choose to use, configure the Kit via the playwright.atk.config.js or cypress.atk.config.js files.


## FAQ

**Q: I'm just starting. Which testing framework should I use, Cypress or Playwright or
something else?**

**A:** You'll find many videos and blog posts comparing the tools
in the [Learning Resources](https://performantlabs.com/automated-testing-kit/learning-resources) area of the documentation.


## Maintainers

- André Angelantoni ([aangel](https://www.drupal.org/u/aangel))
- Ilia Liaukin ([ilyaukin](https://www.drupal.org/u/ilyaukin))
