/**
 * atk_cors.cy.js
 *
 * Validate CORS protection.
 *
 */

/** ESLint directives */
/* eslint-disable import/first */

/// <reference types='Cypress' />

// Set up ATK.
import * as atkCommands from '../../support/atk_commands' // eslint-disable-line no-unused-vars
// eslint-disable-next-line no-unused-vars
import * as atkUtilities from '../../support/atk_utilities'
// eslint-disable-next-line no-unused-vars
import atkConfig from '../../../cypress.atk.config'

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
// eslint-disable-next-line no-unused-vars
import qaUserAccounts from '../../data/qaUsers.json'

describe('CORS Tests', () => {
  it('(ATK-CY-1210) should block cross-origin request ', { tags: ['@ATK-1210', '@fedramp', '@cors'] }, () => {
    cy.origin('example.com', () => {
      cy.visit('https://example.com')
      cy.window().then((win) => win.fetch(Cypress.config('baseUrl')).then((response) => response.status).catch(() => 403)).then((statusCode) => {
        expect(statusCode).eq(403)
      })
    })
  })

  it('(ATK-CY-1211) should block cross-origin pre-flight OPTIONS request', { tags: ['@ATK-1211', '@fedramp', '@cors'] }, () => {
    cy.origin('example.com', () => {
      cy.visit('https://example.com')
      cy.window().then((win) => win.fetch(`${Cypress.config('baseUrl')}/user/login`, {
        method: 'OPTIONS',
        headers: {
          'Access-Control-Request-Method': 'POST',
        },
      }).then((response) => response.status).catch(() => 403)).then((statusCode) => {
        expect(statusCode).eq(403)
      })
    })
  })
})
