/**
 * atk_rapid_login.cy.js
 *
 * Validate rapid logins.
 *
 */

/** ESLint directives */
/* eslint-disable import/first */

/// <reference types='Cypress' />

// Set up ATK.
import * as atkCommands from '../../support/atk_commands' // eslint-disable-line no-unused-vars
import * as atkUtilities from '../../support/atk_utilities'
// eslint-disable-next-line no-unused-vars
import atkConfig from '../../../cypress.atk.config'

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
// eslint-disable-next-line no-unused-vars
import qaUserAccounts from '../../data/qaUsers.json'

describe('Rapid Login Tests', () => {
  it('(ATK-CY-1200) should block rapid logins ', { tags: ['@ATK-1200', '@fedramp', '@rapid-login'] }, () => {
    // Create a user via Drush.
    const account = atkUtilities.createRandomUser()
    cy.createUserWithUserObject(account)

    // Limit of successful logins.
    const limit = 3

    // Count of successful logins.
    let count = 0
    for (count = 0; count < limit; count += 1) {
      cy.logInViaForm(account, count)
      cy.visit('/')
      cy.contains('Log out').should('exist')
    }

    // 4th login must be banned.
    cy.logInViaForm(account, count)
    cy.visit('/')
    cy.contains('Log out').should('not.exist')
  })

  it('(ATK-CY-1201) should block rapid login attempts ', { tags: ['@ATK-1201', '@fedramp', '@rapid-login'] }, () => {
    // Create a user via Drush.
    const account = atkUtilities.createRandomUser()
    cy.createUserWithUserObject(account)

    // Limit of login attempts.
    const limit = 3

    // Count login attempts.
    let count = 0
    for (count = 0; count < limit; count += 1) {
      cy.logInViaForm({ ...account, userPassword: atkUtilities.createRandomString(10) }, count)
    }

    // Now login with the correct password must be blocked.
    cy.logInViaForm(account, count)
    cy.visit('/')
    cy.contains('Log out').should('not.exist')
  })
})
