/**
 * atk_encryption.spec.js
 *
 * Ensure HTTPS is used.
 */

/** ESLint directives */
/* eslint-disable import/first */

// Set up Playwright.
import { expect, test } from '@playwright/test'

import * as atkCommands from '../support/atk_commands'
// eslint-disable-next-line no-unused-vars
import * as atkUtilities from '../support/atk_utilities'

import playwrightConfig from '../../playwright.config'

// eslint-disable-next-line no-unused-vars
const baseUrl = playwrightConfig.use.baseURL

// Import ATK Configuration.
// eslint-disable-next-line no-unused-vars
import atkConfig from '../../playwright.atk.config'

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
// eslint-disable-next-line no-unused-vars
import qaUserAccounts from '../data/qaUsers.json'

test.describe('Fed RAMP mandates the use of cryptographic mechanisms', () => {
  //
  // Test that HTTP redirects to HTTPS.
  //
  test('(ATK-PW-1240) HTTP must redirect to HTTPS', async ({ page }) => {
    const httpURL = baseUrl.replace('https://', 'http://')
    await page.goto(httpURL)

    // Test that we've been redirected.
    expect(page.url()).toEqual(baseUrl)
  })
})
