/**
 * atk_rapid_login.spec.js
 *
 * FedRAMP rapid login security tests.
 */

/** ESLint directives */
/* eslint-disable import/first */

// Set up Playwright.
import { expect, test } from '@playwright/test'

import * as atkCommands from '../support/atk_commands'
import * as atkUtilities from '../support/atk_utilities'

import playwrightConfig from '../../playwright.config'

// eslint-disable-next-line no-unused-vars
const baseUrl = playwrightConfig.use.baseURL

// Import ATK Configuration.
// eslint-disable-next-line no-unused-vars
import atkConfig from '../../playwright.atk.config'

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
// eslint-disable-next-line no-unused-vars
import qaUserAccounts from '../data/qaUsers.json'

test.describe('Fed RAMP rapid login security test', () => {
  // Temporary users that should be cleaned up after the test run.
  const tmpUsers = []

  //
  // Multiple rapid logins via GUI
  //
  test('(ATK-PW-1200) Multiple rapid logins via GUI. @ATK-PW-1200 @fedramp @register-login @multiple-logins', async ({ browser }) => {
    const account = atkUtilities.createRandomUser()
    tmpUsers.push(account)
    atkCommands.createUserWithUserObject(account)
    const maxLoginCount = 3
    // eslint-disable-next-line no-plusplus
    for (let loginCount = 1; loginCount <= maxLoginCount + 1; loginCount++) {
      // eslint-disable-next-line no-await-in-loop
      const context = await browser.newContext()
      // eslint-disable-next-line no-await-in-loop
      const page = await context.newPage()
      let isSuccessful = true
      try {
        // eslint-disable-next-line no-await-in-loop
        await atkCommands.logInViaForm(page, context, account)
      } catch (e) {
        isSuccessful = false
      }
      // Check that unsuccessful login is exact maxLoginCount + 1
      if (loginCount <= maxLoginCount) {
        expect(isSuccessful, { message: `Successful login #${loginCount}` })
          .toBeTruthy()
      } else {
        expect(isSuccessful, { message: `Successful login #${loginCount}` })
          .toBeFalsy()
      }
    }
  })

  //
  // Multiple unsuccessful rapid logins via GUI
  //
  test('(ATK-PW-1201) Multiple unsuccessful rapid logins via GUI. @ATK-PW-1201 @fedramp @register-login @multiple-logins', async ({ browser }) => {
    const account = atkUtilities.createRandomUser()
    tmpUsers.push(account)
    atkCommands.createUserWithUserObject(account)
    const maxLoginCount = 3
    // eslint-disable-next-line no-plusplus
    for (let loginCount = 1; loginCount <= maxLoginCount + 1; loginCount++) {
      // eslint-disable-next-line no-await-in-loop
      const context = await browser.newContext()
      // eslint-disable-next-line no-await-in-loop
      const page = await context.newPage()
      let isSuccessful = true
      // Check that unsuccessful login is exact maxLoginCount + 1
      if (loginCount <= maxLoginCount) {
        try {
          // eslint-disable-next-line no-await-in-loop
          await atkCommands.logInViaForm(page, context, {
            ...account, userPassword: atkUtilities.createRandomString(10),
          })
        } catch (e) {
          isSuccessful = false
        }
        expect(!isSuccessful, { message: `Unsuccessful login #${loginCount}` })
          .toBeTruthy()
      } else {
        try {
          // eslint-disable-next-line no-await-in-loop
          await atkCommands.logInViaForm(page, context, account)
        } catch (e) {
          isSuccessful = false
        }
        expect(isSuccessful, { message: `Successful login #${loginCount}` })
          .toBeFalsy()
      }
    }
  })

  test.afterAll(() => {
    // Uncomment for debugging.
    // console.log(`Cleaning up users:\n${JSON.stringify(tmpUsers, null, 2)}`)
    tmpUsers.forEach((user) => {
      atkCommands.deleteUserWithUserName(user.userName, ['--delete-content'])
    })
  })
})
