/**
 * atk_session_termination.spec.js
 *
 * Session termination after inactivity tests.
 */

/** ESLint directives */
/* eslint-disable import/first */

// Set up Playwright.
import { expect, test } from '@playwright/test'

import * as atkCommands from '../support/atk_commands'
import * as atkUtilities from '../support/atk_utilities'

import playwrightConfig from '../../playwright.config'

// eslint-disable-next-line no-unused-vars
const baseUrl = playwrightConfig.use.baseURL

// Import ATK Configuration.
// eslint-disable-next-line no-unused-vars
import atkConfig from '../../playwright.atk.config'

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
// eslint-disable-next-line no-unused-vars
import qaUserAccounts from '../data/qaUsers.json'

test.describe('Fed RAMP session termination test', () => {
  //
  // Test session termination after inactivity.
  // **IMPORTANT!!!**
  // To set up site for this test, do the following,
  // * install "Automated Logout" module: composer require 'drupal/autologout:^2.0'
  // * enable the module
  // * create a new role "Autologout Testing"
  // * in the Automated Logout Settings (admin/config/people/autologout) tick
  //   Role Timeout and for the new role specify timeout 60.
  //
  // Also, in playwright.config.js increase timeout to more than 60 sec.
  //
  test('(ATK-PW-1220) Session termination by inactivity @ATK-PW-1220 @fedramp @session-termination', async ({ page, context }) => {
    const account = atkUtilities.createRandomUser()
    account.userRoles.push('autologout_testing')
    await atkCommands.createUserWithUserObject(account)

    // Log in as a newly created user.
    await atkCommands.logInViaForm(page, context, account)

    // Check that user is logged out and the configured message is shown.
    // (timeouts in the settings are not accurate, so wait more here.)
    await expect(page.getByText('Log out')).not.toBeVisible({ timeout: 180000 })
    await atkCommands.expectMessage(page, 'You have been logged out due to inactivity.')
  })
})
