/**
 * atk_session_termination.cy.js
 *
 * Validate session termination due to inactivity.
 *
 */

/** ESLint directives */
/* eslint-disable import/first */

/// <reference types='Cypress' />

// Set up ATK.
import * as atkCommands from '../../support/atk_commands' // eslint-disable-line no-unused-vars
import * as atkUtilities from '../../support/atk_utilities'
// eslint-disable-next-line no-unused-vars
import atkConfig from '../../../cypress.atk.config'

// Standard accounts that use user accounts created
// by QA Accounts. QA Accounts are created when the QA
// Accounts module is enabled.
// eslint-disable-next-line no-unused-vars
import qaUserAccounts from '../../data/qaUsers.json'

describe('Inactive session termination', () => {
  //
  // Test session termination after inactivity.
  // **IMPORTANT!!!**
  // To set up site for this test, do the following,
  // * install "Automated Logout" module: composer require 'drupal/autologout:^2.0'
  // * enable the module
  // * create a new role "Autologout Testing"
  // * in the Automated Logout Settings (admin/config/people/autologout) tick
  //   Role Timeout and for the new role specify timeout 60.
  //
  // Also, in playwright.config.js increase timeout to more than 60 sec.
  //
  it('(ATK-CY-1220) should terminate inactive session ', { tags: ['@ATK-1220', '@fedramp', '@session'] }, () => {
    const account = atkUtilities.createRandomUser()
    account.userRoles.push('autologout_testing')
    cy.createUserWithUserObject(account)

    // Log in as a newly created user.
    cy.logInViaForm(account)
    cy.visit('/')

    // Check that user is logged out and the configured message is shown.
    // (timeouts in the settings are not accurate, so wait more here.)
    cy.contains('Log out', { timeout: 180000 }).should('not.exist')
    cy.contains('You have been logged out due to inactivity.')
  })
})
