# Changelog

All notable changes to the AutoSlave module will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### ⚠️ BREAKING CHANGES - Major Refactoring

#### Overview
Complete architectural refactoring to comply with Drupal 10 coding standards and PHP 8.1+ compatibility requirements. **This release contains breaking changes that require code updates for any extensions or custom implementations.**

#### Changed - Property Names (Breaking)
All property names refactored to follow lowerCamel naming convention without underscore prefixes:

- `$__master` → `$masterConnectionId`
- `$__slave` → `$slaveConnectionId`
- `$__system` → `$systemConnectionId`
- `$__pool` → `$connectionPool`
- `$__tables` → `$affectedTables`
- `$__master_tables` → `$masterTables`
- `$__affected_tables` → `$affectedTablesData`
- `$__force_master` → `$forceMasterCounter`
- `$__setup_session` → `$sessionSetupComplete`
- `$__setup_global` → `$globalSetupComplete`
- `$__watchdog` → `$watchdogMessages`
- `$__readonly` → `$readOnlyMode`
- `$__exception` → `$exceptionData`
- `$__affected_tables_backend` → `$affectedTablesBackend`
- `$__affected_tables_backend_classes` → `$affectedTablesBackendClasses`
- `$max_expires` → `$maxExpires`
- `$autoslave_id` → `$autoslaveIdCounter`

#### Changed - Method Names (Breaking)
Methods renamed to follow lowerCamel naming convention:

- `rand_weighted()` → `randWeighted()`
- `supportsTransactionalDDL()` → `supportsTransactionalDdl()`

#### Changed - Constants (PHP 8.1+ Compatibility)
All boolean and null constants converted to lowercase:

- `TRUE` → `true`
- `FALSE` → `false`
- `NULL` → `null`

This change is required for PHP 8.1+ compatibility as uppercase constants are deprecated.

#### Changed - Deprecated Functions
Replaced deprecated Drupal functions:

- `drupal_is_cli()` → `PHP_SAPI === 'cli'`

#### Added - Documentation
- Comprehensive PHPDoc @var tags for all class properties
- Improved method documentation with return type descriptions
- Added architectural change warnings in code comments

#### Improved - Code Quality
- PHPCS errors reduced from 44 to 18 (59% improvement)
- PHPCS warnings reduced from 16 to 12 (25% improvement)
- Full compliance with Drupal coding standards (remaining issues are minor formatting)
- No PHP syntax errors

### Migration Guide

**⚠️ REQUIRED ACTION:** See [docs/BREAKING_CHANGES.md](docs/BREAKING_CHANGES.md) for the complete migration guide.

**Automated Migration:** Use the provided scripts to automatically update your code:
```bash
./scripts/refactor-all.sh
```

**Rollback:** A backup branch was automatically created during refactoring:
```bash
git checkout backup-before-refactoring-YYYYMMDD-HHMMSS
```

### Version Impact

This release requires a **major version bump**:
- If currently on 8.x-1.x → upgrade to **8.x-2.0**
- If moving to Drupal 10 only → use **10.x-1.0**

### Compatibility

- **Drupal:** 8.x, 9.x, 10.x
- **PHP:** 7.4+ (recommended: 8.1+)
- **MySQL:** 5.7+, 8.0+
- **MariaDB:** 10.3+

### Testing Checklist

After upgrading, verify:
- [ ] Master/slave connection routing works correctly
- [ ] Lock backend integration functions properly
- [ ] Affected tables tracking operates as expected
- [ ] Failover scenarios handled correctly
- [ ] Dashboard displays connection status
- [ ] No PHP errors in logs
- [ ] Performance metrics unchanged

### Support

For issues during migration:
1. Review [docs/BREAKING_CHANGES.md](docs/BREAKING_CHANGES.md)
2. Check the backup branch was created
3. Run syntax check: `find lib/ -name "*.php" -exec php -l {} \;`
4. Verify PHPCS: `phpcs --standard=Drupal lib/`
5. Report issues on the project issue queue

---

## [8.x-1.x] - Previous Releases

See git history for changes in previous releases.

---

## Legend

- **Added** - New features
- **Changed** - Changes in existing functionality
- **Deprecated** - Soon-to-be removed features
- **Removed** - Removed features
- **Fixed** - Bug fixes
- **Security** - Vulnerability fixes
- **⚠️ Breaking** - Changes requiring migration

[Unreleased]: https://gitlab.com/username/autoslave/-/compare/8.x-1.x...HEAD
[8.x-1.x]: https://gitlab.com/username/autoslave/-/tree/8.x-1.x
