<?php

/**
 * @file
 * AutoSlave select query injector class definition.
 */

use Drupal\Core\Database\Query\Select as QuerySelect;

/**
 * Helper class to change database connection for select queries.
 */
class AutoSlaveSelectQueryInjector extends QuerySelect {

  /**
   * Changes the database connection for a given query.
   *
   * @param object $query
   *   The query object.
   * @param object $connection
   *   The new database connection.
   */
  public static function changeConnection($query, $connection) {
    $query->connection = $connection;
  }

}
