((Drupal) => {

  'use strict';

  /**
   * Initializes AXE Core Drupal integration.
   */
  Drupal.behaviors.initializeAxeCore = {
    attach: (context, settings) => {
      once('axe-core-init', '.axe-core', context).forEach(block => {
        // Namespace.
        const id_space = block.getAttribute('data-id-space');

        // When a tab is clicked, update the selected one and the visible panel.
        const tabs = block.querySelectorAll('.axe-core__validation-tab');
        tabs.forEach(tab => {
          tab.addEventListener('click', e => {
            tabs.forEach(tab => {
              tab.setAttribute('aria-selected', 'false');
              tab.setAttribute('tabindex', '-1');
            });
            tab.setAttribute('aria-selected', 'true');
            tab.setAttribute('tabindex', '0');
            block.querySelectorAll('.axe-core__validation-group').forEach(panel => {
              panel.setAttribute('hidden', '');
            });
            document.getElementById(e.currentTarget.getAttribute('aria-controls')).removeAttribute('hidden');
          });
        });

        // Container map.
        const map = {
          'violations': document.getElementById(`axe-core-panel-violations-${id_space}`),
          'incomplete': document.getElementById(`axe-core-panel-incomplete-${id_space}`),
          'passes': document.getElementById(`axe-core-panel-passes-${id_space}`),
        };

        // When the validation button is clicked...
        const button = block.querySelector('[data-action="validate"]');
        button.addEventListener('click', e => {

          // Cleans up previous validation results.
          for (let group in map) {
            map[group].innerHTML = '';
          }

          // Runs validations based on standards.
          axe
            .run('html', {
              runOnly: button.getAttribute('data-standard').split('|'),
            })
            .then(results => {

              // For each validation group panel...
              for (let group in map) {
                // Updates the results count for the panel.
                const panel = map[group];
                const tabCount = document.querySelector(`#${panel.getAttribute('aria-labelledby')} .axe-core__validation-count`);
                tabCount.innerHTML = ` (${results[group].length + 1})`;

                // And for each result...
                for (let result of results[group]) {
                  // Adds the formatted message to the panel.
                  const text = document.createTextNode(result.description);
                  const div =document.createElement('div');
                  div.classList.add('axe-core__validation-item');
                  div.appendChild(text);
                  panel.appendChild(div);

                  // Skips explaining on passes.
                  if (group == 'passes') {
                    continue;
                  }

                  // Adds each instance that needs correction.
                  for (let tag of result.nodes) {
                    const pre = document.createElement('pre');
                    pre.classList.add('axe-core__validation-summary')
                    const text = document.createTextNode(tag.failureSummary);
                    pre.appendChild(text);
                    div.appendChild(pre);

                    // If a specific tag with the issue is found, creates a button
                    // to link to it.
                    if (tag.target.length > 0) {
                      const target = document.createElement('button');
                      target.type = 'button';
                      target.setAttribute('data-selector', tag.target[0]);
                      target.innerHTML = Drupal.t('Element: ');
                      const label = document.createElement('em');
                      label.innerHTML = tag.target[0];
                      target.appendChild(label);
                      div.appendChild(target);

                      // When the button link to it is clicked, adds a sign, scrolls to the element, animates and removes it.
                      target.addEventListener('click', e => {
                        const selector = e.currentTarget.getAttribute('data-selector');
                        const el = document.querySelector(selector);
                        const sign = document.createElement('span');
                        sign.classList.add('axe-core-sign');
                        sign.innerHTML = '<span class="axe-core-sign__text" hidden>ℹ️</span>';
                        el.parentElement.insertBefore(sign, el);
                        el.scrollIntoView({ behavior: 'instant', block: 'center' });
                        setTimeout(() => {
                          sign.querySelector('.axe-core-sign__text').removeAttribute('hidden');
                        }, 250);
                      });
                    }
                  }
                }
              }
            })
            .catch(err => {
              console.error('Something bad happened:', err.message);
            });
        });
      })
    }
  };

})(Drupal);
