<?php

declare(strict_types=1);

namespace Drupal\axe_core\Plugin\Block;

use Drupal\Component\Utility\Random;
use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides an axe core accessibility checker block.
 */
#[Block(
  id: 'axe_core_accessibility_checker',
  admin_label: new TranslatableMarkup('Axe Core Accessibility Checker'),
  category: new TranslatableMarkup('Axe Core'),
)]
final class AxeCoreAccessibilityCheckerBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'standard' => NULL,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function blockForm($form, FormStateInterface $form_state): array {
    $form['standard'] = [
      '#empty_option' => $this->t('- Select a standard -'),
      '#default_value' => $this->configuration['standard'],
      '#options' => [
        'wcag22aa' => $this->t('WCAG 2.2 Level AA'),
        'wcag21aa' => $this->t('WCAG 2.1 Level AA'),
        'wcag21a' => $this->t('WCAG 2.1 Level A'),
        'wcag2aaa' => $this->t('WCAG 2.0 Level AAA'),
        'wcag2aa' => $this->t('WCAG 2.0 Level AA'),
        'wcag2a' => $this->t('WCAG 2.0 Level A'),
      ],
      '#multiple' => TRUE,
      '#required' => TRUE,
      '#title' => $this->t('Accessibility Standard'),
      '#type' => 'select',
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function blockSubmit($form, FormStateInterface $form_state): void {
    $this->configuration['standard'] = $form_state->getValue('standard');
  }

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $random = new Random();
    $build['validator'] = [
      '#theme' => 'axe_core_validator',
      '#standard' => $this->configuration['standard'],
      '#id_space' => $random->name(8),
    ];
    return $build;
  }
}
