<?php

namespace Drupal\azure_ad\Form;

use Drupal;
use Drupal\azure_ad\moAzureADSupport;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\RedirectCommand;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

class MoAzureCustomerRequest extends FormBase
{

    private ImmutableConfig $config;
    protected $messenger;

    public function __construct()
    {
        $this->config = Drupal::config('user_provisioning.settings');
        $this->messenger = Drupal::messenger();
    }

    /**
     * @inheritDoc
     */
    public function getFormId()
    {
        return 'mo_azure_request_customer_support';
    }

    /**
     * @inheritDoc
     */
    public function buildForm(array $form, FormStateInterface $form_state)
    {
        $form['#prefix'] = '<div id="modal_example_form">';
        $form['#suffix'] = '</div>';
        $form['status_messages'] = [
            '#type' => 'status_messages',
            '#weight' => -10,
        ];

        $user_email = $this->config->get('user_provisioning_customer_admin_email');
        $form['mo_azure_ad_customer_support_email_address'] = [
            '#type' => 'email',
            '#title' => t('Email'),
            '#default_value' => $user_email,
            '#required' => true,
            '#attributes' => array('placeholder' => t('Enter valid email'), 'style' => 'width:99%;margin-bottom:1%;'),
        ];

        $form['mo_azure_ad_customer_support_method'] = [
            '#type' => 'select',
            '#title' => t('What are you looking for'),
            '#attributes' => array('style' => 'width:99%;height:30px;margin-bottom:1%;'),
            '#options' => [
                'I need Technical Support' => t('I need Technical Support'),
                'I want to Schedule a Setup Call/Demo' => t('I want to Schedule a Setup Call/Demo'),
                'I have Sales enquiry' => t('I have Sales enquiry'),
                'I have a custom requirement' => t('I have a custom requirement'),
                'My reason is not listed here' => t('My reason is not listed here'),
            ],
        ];

        $form['mo_azure_ad_customer_support_query'] = array(
            '#type' => 'textarea',
            '#required' => true,
            '#title' => t('How can we help you?'),
            '#attributes' => array('placeholder' => t('Describe your query here!'), 'style' => 'width:99%'),
        );

        $form['actions'] = array('#type' => 'actions');
        $form['actions']['send'] = [
            '#type' => 'submit',
            '#value' => $this->t('Submit'),
            '#attributes' => [
                'class' => [
                    'use-ajax',
                    'button--primary'
                ],
            ],
            '#ajax' => [
                'callback' => [$this, 'submitModalFormAjax'],
                'event' => 'click',
            ],
        ];

        $form['#attached']['library'][] = 'core/drupal.dialog.ajax';
        return $form;
    }

    public function submitModalFormAjax(array $form, FormStateInterface $form_state) {
        $form_values = $form_state->getValues();
        $response = new AjaxResponse();
      $email = $form_values['mo_azure_ad_customer_support_email_address'];
        // If there are any form errors, AJAX replace the form.
        if ( $form_state->hasAnyErrors() ) {
            $response->addCommand(new ReplaceCommand('#modal_example_form', $form));
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
          \Drupal::messenger()->addMessage(t('The email address @email is not valid.', ['@email' => $email]), 'error');
          $response->addCommand(new ReplaceCommand('#modal_example_form', $form));
        }else {
            $support_for = $form_values['mo_azure_ad_customer_support_method'];
            $query = $form_values['mo_azure_ad_customer_support_query'];
            $query_type = 'Contact Support';

            $support = new moAzureADSupport($email, $support_for, $query, $query_type);
            $support_response = $support->sendSupportQuery();

            $this->messenger->addStatus(t('Support query successfully sent. We will get back to you shortly.'));
            $response->addCommand(new RedirectCommand(Url::fromRoute('azure_ad.overview')->toString()));
        }
        return $response;
    }

    /**
     * @inheritDoc
     */
    public function submitForm(array &$form, FormStateInterface $form_state)
    {
        // TODO: Implement submitForm() method.
    }
}
