<?php

namespace Drupal\azure_ad\Form;

use Drupal;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Ajax\RedirectCommand;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\azure_ad\MoAzureUtilities;
use Drupal\user_provisioning\moUserProvisioningSupport;

class MoAzureRequestSupportForm extends FormBase
{
    private ImmutableConfig $config;
    protected $messenger;

    public function __construct()
    {
        $this->config = Drupal::config('user_provisioning.settings');
        $this->messenger = Drupal::messenger();
    }

    public function getFormId() {
        return 'mo_azure_request_support';
    }

    public function buildForm(array $form, FormStateInterface $form_state, $options = NULL) {
        $form['#prefix'] = '<div id="modal_support_form">';
        $form['#suffix'] = '</div>';
        $form['status_messages'] = [
            '#type' => 'status_messages',
            '#weight' => -10,
        ];

        $form['markup_library'] = array(
          '#attached' => array(
            'library' => array(
              "azure_ad/azure_ad.admin",
            )
          ),
        );

        $user_email = $this->config->get('mo_user_provisioning_customer_email');
        $phone = $this->config->get('mo_user_provisioning_customer_phone');

        $form['markup_1'] = array(
          '#markup' => t('<p class="mo_azure_background_note">Need any help? We can help you with configuring miniOrange Azure AD Sync module on your site. Just send us a query, and we will get back to you soon.</p>'),
        );

        $form['mo_user_provisioning_support_email_address'] = array(
          '#type' => 'email',
          '#title' => t('Email'),
          '#default_value' => $user_email,
          '#required' => true,
          '#attributes' => array('placeholder' => t('Enter your email'), 'style' => 'width:99%;margin-bottom:1%;'),
        );
        $form['mo_user_provisioning_support_phone_number'] = array(
          '#type' => 'textfield',
          '#title' => t('Phone'),
          '#default_value' => $phone,
          '#attributes' => array('placeholder' => t('Enter number with country code Eg. +00xxxxxxxxxx'), 'style' => 'width:99%;margin-bottom:1%;'),
        );
        $form['mo_user_provisioning_support_query'] = array(
          '#type' => 'textarea',
          '#required' => true,
          '#title' => t('Query'),
          '#attributes' => array('placeholder' => t('Describe your query here!'), 'style' => 'width:99%'),
        );

        $form['actions'] = array('#type' => 'actions');
        $form['actions']['send'] = [
          '#type' => 'submit',
          '#value' => $this->t('Submit'),
          '#attributes' => [
            'class' => [
              'use-ajax',
              'button--primary'
            ],
          ],
          '#ajax' => [
            'callback' => [$this, 'submitModalFormAjax'],
            'event' => 'click',
          ],
        ];

        $form['#attached']['library'][] = 'core/drupal.dialog.ajax';
        return $form;
    }

    public function submitModalFormAjax(array $form, FormStateInterface $form_state) {
        $form_values = $form_state->getValues();
        $response = new AjaxResponse();
        $email = $form_values['mo_user_provisioning_support_email_address'];
        // If there are any form errors, AJAX replace the form.
        if ( $form_state->hasAnyErrors() ) {
            $response->addCommand(new ReplaceCommand('#modal_support_form', $form));
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
          \Drupal::messenger()->addMessage(t('The email address @email is not valid.', ['@email' => $email]), 'error');
          $response->addCommand(new ReplaceCommand('#modal_support_form', $form));
        }else {
          $phone = $form_values['mo_user_provisioning_support_phone_number'];
          $query = $form_values['mo_user_provisioning_support_query'];
          $query_type = 'Support';
          $module_name = 'Azure AD Sync';
          $utilities = new MoAzureUtilities();
          $module_version = $utilities->getModuleVersion();

          $support = new moUserProvisioningSupport($email, $phone, $query, $query_type, null, $module_name, $module_version);
          $support_response = $support->sendSupportQuery();

          $this->messenger->addStatus(t('Support query successfully sent. We will get back to you shortly.'));
          $response->addCommand(new RedirectCommand(Url::fromRoute('azure_ad.overview')->toString()));
        }
        return $response;
    }

    public function validateForm(array &$form, FormStateInterface $form_state) { }

    public function submitForm(array &$form, FormStateInterface $form_state) { }

}
