<?php

declare(strict_types=1);

namespace Drupal\Tests\b24_commerce\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test b24_commerce module mapping settings form.
 *
 * @group b24
 */
final class MappingFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['b24_commerce', 'commerce'];

  /**
   * Test callback.
   */
  public function testForm(): void {
    $this->drupalGet('admin/config/b24/commerce/mapping');
    $this->assertSession()->statusCodeEquals(403);

    $admin_user = $this->drupalCreateUser(['administer b24 configuration']);
    $this->drupalLogin($admin_user);
    $this->drupalGet('admin/config/b24/commerce/mapping');
    $this->assertSession()->statusCodeEquals(200);

    $this->assertSession()->elementExists('xpath', '//h1[text() = "Fields mapping"]');

    $this->submitForm([], 'Save configuration');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('The configuration options have been saved. ');
  }

}
