<?php

declare(strict_types=1);

namespace Drupal\Tests\b24_commerce\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test description.
 *
 * @group b24_commerce
 */
final class ProductExportBatchFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['b24_commerce'];

  /**
   * Test callback.
   */
  public function testForm(): void {
    $this->drupalGet('/admin/config/b24/commerce/export_products');
    $this->assertSession()->statusCodeEquals(403);
    $admin_user = $this->drupalCreateUser(['administer b24 configuration']);
    $this->drupalLogin($admin_user);
    $this->drupalGet('/admin/config/b24/commerce/export_products');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->elementExists('xpath', '//h1[text() = "Products Export"]');
    $this->submitForm([], 'Save');
    $this->assertSession()->statusCodeEquals(200);
    $this->submitForm([], 'Export');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Choose store to export from.');
  }

}
