<?php

namespace Drupal\b24_user\EventSubscriber;

use Drupal\b24\Service\ReferenceManager;
use Drupal\b24_commerce\Event\B24CommerceEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber.
 */
class B24UserEventSubscriber implements EventSubscriberInterface {

  /**
   * The b24 reference manager.
   *
   * @var \Drupal\b24\Service\ReferenceManager
   */
  protected ReferenceManager $referenceManager;

  /**
   * Constructs a new B24UserEventSubscriber object.
   */
  public function __construct(ReferenceManager $reference_manager) {
    $this->referenceManager = $reference_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events['b24_commerce.entity.insert'] = ['onEntityInsert'];

    return $events;
  }

  /**
   * Called whenever the b24_commerce.entity.insert event is dispatched.
   *
   * If a contact has been created by b24_commerce module by converting from a
   * lead we add it to our reference table to notify b24_user module.
   *
   * @param \Drupal\b24_commerce\Event\B24CommerceEvent $event
   *   The B24CommerceEvent event.
   */
  public function onEntityInsert(B24CommerceEvent $event) {
    if ($event->getName() == 'contact') {
      if ($ext_id = $event->getResponse()) {
        $uid = $event->getOrder()->getCustomerId();
        $this->referenceManager->addReference($uid, 'user', $ext_id, 'contact');
      }
    }
  }

}
