<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a data transfer attribute object.
 *
 * A data transfer plugin can be an importer or an exporter or both.
 *
 * Plugin Namespace: Plugin\Babel\DataTransfer.
 *
 * @see \Drupal\babel\Plugin\Babel\DataTransferPluginInterface
 * @see \Drupal\babel\Plugin\Babel\DataTransferPluginManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class DataTransfer extends Plugin {

  /**
   * Provides an attribute for Babel data transfer plugins.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The plugin label.
   * @param string[] $fileExtensions
   *   List of file extensions.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly array $fileExtensions,
  ) {}

}
