<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

/**
 * Interface for importer data transfer plugins.
 */
interface ImporterPluginInterface extends DataTransferPluginInterface {

  /**
   * Imports file data into the backend and return the translations.
   *
   * @param string $path
   *   The local path to the imported file.
   * @param string $langcode
   *   The language code.
   *
   * @return array<array-key, list<string>>
   *   Associative array with source string hashes as keys and a list of
   *   translated string plural variants as values.
   */
  public function getImportedTranslations(string $path, string $langcode): array;

  /**
   * Return a list of errors gathered during import.
   *
   * @return list<\Drupal\Core\StringTranslation\TranslatableMarkup>
   *   Translated error messages.
   */
  public function getImportErrors(): array;

  /**
   * Return a list of warnings gathered during import.
   *
   * @return list<\Drupal\Core\StringTranslation\TranslatableMarkup>
   *   Translated warning messages.
   */
  public function getImportWarnings(): array;

}
