<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

/**
 * Exporter plugins interface.
 */
interface ExporterPluginInterface extends DataTransferPluginInterface {

  /**
   * Generates the export file content.
   *
   * @param array<array-key, \Drupal\babel\Model\StringTranslation> $strings
   *   List of string objects.
   * @param string $langcode
   *   The translation language code.
   * @param string $extension
   *   The file extension.
   *
   * @return string
   *   The content of the exported file.
   */
  public function createExportedFileContent(array $strings, string $langcode, string $extension): string;

}
