<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Reusable code for importer data transfer plugins.
 */
trait ImporterPluginTrait {

  /**
   * Errors collected during import.
   *
   * @var list<\Drupal\Core\StringTranslation\TranslatableMarkup>
   */
  protected array $errors = [];

  /**
   * Warnings collected during import.
   *
   * @var list<\Drupal\Core\StringTranslation\TranslatableMarkup>
   */
  protected array $warnings = [];

  /**
   * {@inheritdoc}
   */
  public function getImportErrors(): array {
    return $this->errors;
  }

  /**
   * {@inheritdoc}
   */
  public function getImportWarnings(): array {
    return $this->warnings;
  }

  /**
   * Add a new error to the stack.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $message
   *   The translated error message.
   *
   * @return $this
   */
  protected function addImportError(TranslatableMarkup $message): ImporterPluginInterface {
    $this->errors[] = $message;
    return $this;
  }

  /**
   * Add a new warning to the stack.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $message
   *   The translated warning message.
   *
   * @return $this
   */
  protected function addImportWarning(TranslatableMarkup $message): ImporterPluginInterface {
    $this->warnings[] = $message;
    return $this;
  }

}
