<?php

declare(strict_types=1);

namespace Drupal\babel;

/**
 * Utilities.
 */
class Utility {

  /**
   * Returns an ordinal given an integer.
   *
   * @param int $number
   *   The integer.
   *
   * @return string
   *   The ordinal representation.
   */
  public static function getOrdinal(int $number): string {
    $suffix = ['th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th'];
    if ((($number % 100) >= 11) && (($number % 100) <= 13)) {
      return $number . 'th';
    }
    else {
      return $number . $suffix[$number % 10];
    }
  }

}
