<?php

declare(strict_types=1);

namespace Drupal\babel_test\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Testing module hooks.
 */
class BabelTestHooks {

  /**
   * Sets the 'locale' plugin status to FALSE.
   *
   * @phpstan-ignore-next-line as Attribute class Drupal\Core\Hook\Attribute\Hook does not exist.
   */
  #[Hook('babel_translation_type_info_alter')]
  public function alterTranslationTypeInfo(array &$definitions): void {
    $definitions['locale']['status'] = FALSE;
  }

}
