<?php

declare(strict_types=1);

namespace Drupal\Tests\babel\Kernel\Plugin\Babel\TranslationType;

use Drupal\babel\Plugin\Babel\TranslationTypePluginInterface;
use Drupal\Tests\babel\Kernel\BabelKernelTestBase;

/**
 * Base test class for testing TranslationType plugins.
 *
 * @coversDefaultClass \Drupal\babel\Plugin\Babel\TranslationTypePluginBase
 */
abstract class TranslationTypePluginTestBase extends BabelKernelTestBase {

  /**
   * The plugin instance to be used in the test.
   */
  protected ?TranslationTypePluginInterface $plugin;

  /**
   * Tests loading of multiple strings.
   *
   * @covers ::getStrings
   */
  abstract public function testGetStrings(): void;

  /**
   * Tests loading a single string (after install).
   *
   * @covers ::getString
   */
  abstract public function testGetString(): void;

  /**
   * Tests how translations are updated.
   *
   * @covers ::updateTranslation
   */
  abstract public function testUpdateTranslation(): void;

}
