<?php

declare(strict_types=1);

namespace Drupal\Tests\babel\Kernel\Plugin\Babel\TranslationType;

use Drupal\babel\BabelStorageInterface;
use Drupal\babel\Model\Source;
use Drupal\KernelTests\KernelTestBase;

/**
 * Regression tests.
 *
 * @group babel
 */
class RegressionTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'babel',
    'language',
    'locale',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installSchema('locale', [
      'locales_source',
      'locales_target',
      'locales_location',
    ]);
    $this->installSchema('babel', ['babel_source', 'babel_source_instance']);
  }

  /**
   * @covers \Drupal\babel\BabelLocaleTranslation
   * @covers \Drupal\babel\BabelLocaleLookup
   * @see https://www.drupal.org/i/3545152
   */
  public function testIssue3545152(): void {
    $localeStorage = $this->container->get('locale.storage');
    $babelStorage = $this->container->get(BabelStorageInterface::class);

    $foo = new Source('foo', '');
    $bar = new Source('bar', '');

    $options = ['langcode' => 'ro'];

    t('foo', [], $options)->__toString();
    t('bar', [], $options)->__toString();
    // Second call for 'foo' translation in the same request.
    t('foo', [], $options)->__toString();

    // Commit changes.
    $this->container->get('string_translator.locale.lookup')->destruct();

    // Check that correct entries were created for 'foo' source string.
    $fooSid = $localeStorage->getStrings(['source' => 'foo'])[0]->getId();
    $fooInstances = $babelStorage->getSourceStringInstances($foo->getHash());
    $this->assertSame(['locale' => [$fooSid]], $fooInstances);

    // Check that correct entries were created for 'bar' source string.
    $barSid = $localeStorage->getStrings(['source' => 'bar'])[0]->getId();
    $barInstances = $babelStorage->getSourceStringInstances($bar->getHash());
    $this->assertSame(['locale' => [$barSid]], $barInstances);
  }

}
