<?php

declare(strict_types=1);

namespace Drupal\Tests\babel\Functional;

use Drupal\Tests\babel\Traits\BabelFunctionalSetupTrait;
use Drupal\Tests\babel\Traits\TranslationAssertionTrait;
use Drupal\Tests\BrowserTestBase;

/**
 * Base test class for Babel tests not needing JavaScript interpreter.
 */
class BabelFunctionalTestBase extends BrowserTestBase {

  use BabelFunctionalSetupTrait;
  use TranslationAssertionTrait;

  /**
   * Permissions required for operations.
   *
   * @const list<string>
   */
  protected const TEST_USER_PERMISSIONS = [
    'translate interface',
  ];

  /**
   * The ID of the language (language code) used for testing.
   *
   * @const string
   */
  protected const LANGCODE = 'pt-pt';

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'babel',
    'block',
    'language',
    'config_translation',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->babelTestSetup();
  }

}
