<?php

declare(strict_types=1);

namespace Drupal\babel\Element;

use Drupal\Core\Render\Attribute\RenderElement;
use Drupal\Core\Render\Element\Pager;

/**
 * Provides a render element for AJAX pagers in Babel.
 *
 * @code
 * $build['pager'] = [
 *   '#type' => 'babel_pager',
 * ];
 * @endcode
 */
#[RenderElement("pager_babel")]
class BabelPager extends Pager {

  /**
   * {@inheritdoc}
   */
  public function getInfo(): array {
    return [
      '#ajax_links' => TRUE,
      '#theme' => 'pager__babel',
    ] + parent::getInfo();
  }

}
