<?php

declare(strict_types=1);

namespace Drupal\babel\Hook;

use Drupal\Core\Hook\Attribute\ReorderHook;
use Drupal\Core\Hook\Order\OrderAfter;

/**
 * Hook ordering for Babel module (Drupal 11+ only).
 *
 * This class is separate to avoid class loading issues on Drupal 10
 * where OrderAfter and ReorderHook classes don't exist.
 */
class BabelHookOrder {

  /**
   * Reorders js_alter to run after locale (Drupal 11+ only).
   *
   * @phpstan-ignore-next-line as Attribute class Drupal\Core\Hook\Attribute\ReorderHook does not exist.
   */
  #[ReorderHook(
    hook: 'js_alter',
    class: BabelHooks::class,
    method: 'jsAlter',
    // @phpstan-ignore-next-line as Instantiated class Drupal\Core\Hook\Order\OrderAfter not found.
    order: new OrderAfter(['locale'])
  )]
  public function reorderJsAlter(): void {
    // This method exists only to provide hook ordering for Drupal 11.
    // For Drupal 10 compatibility, hook_module_implements_alter() is used.
  }

}
