<?php

/**
 * @file
 * Describes API functions of Babel module.
 */

declare(strict_types=1);

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alters the translation type plugin definitions.
 *
 * @param array $definitions
 *   The translation type plugin definitions to be altered.
 */
function hook_babel_translation_type_info(array &$definitions): void {
  if (isset($definitions['foo'])) {
    $definitions['foo']['class'] = 'Drupal\my_module\Foo';
  }
}

/**
 * Alters the data transfer type plugin definitions.
 *
 * @param array $definitions
 *   The data transfer plugin definitions to be altered.
 */
function hook_babel_data_transfer_info(array &$definitions): void {
  if (isset($definitions['bar'])) {
    $definitions['bar']['class'] = 'Drupal\my_module\Baz';
  }
}

/**
 * @} End of "addtogroup hooks".
 */
