<?php

declare(strict_types=1);

namespace Drupal\babel;

/**
 * Interface for helper service for the 'config' plugin.
 */
interface BabelConfigHelperInterface {

  /**
   * Returns a list of paths to the translatable properties of a config object.
   *
   * @param string $name
   *   The configuration name.
   *
   * @return array<array-key, string>
   *   Associative array where the key is the path to the translatable string,
   *   as a string with dot as separator, and the value is the translation
   *   context.
   */
  public function getTranslatableProperties(string $name): array;

}
