<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a translation type attribute object.
 *
 * Plugin Namespace: Plugin\Babel\TranslationType.
 *
 * @see \Drupal\babel\Plugin\Babel\TranslationTypePluginInterface
 * @see \Drupal\babel\Plugin\Babel\TranslationTypePluginManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class TranslationType extends Plugin {

  /**
   * Provides an attribute for Babel translation type plugins.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The plugin label.
   * @param bool $status
   *   (optional) The source string status suggested by this plugin.
   * @param string|null $deriver
   *   (optional) A deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly bool $status = TRUE,
    public readonly ?string $deriver = NULL,
  ) {}

}
