<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

use Drupal\babel\Model\StringTranslation;
use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Translation type plugin interface.
 */
interface TranslationTypePluginInterface extends PluginInspectionInterface, ConfigurableInterface {

  /**
   * Returns a list of string objects handled by this plugin.
   *
   * @param string $langcode
   *   The results will contain existing translations in the requested language.
   * @param array $ids
   *   The list of the IDs to limit the results.
   *
   * @return array<array-key, \Drupal\babel\Model\StringTranslation>
   *   List of strings keyed by the source ID.
   */
  public function getStrings(string $langcode, array $ids = []): array;

  /**
   * Returns a string object given its ID.
   *
   * @param string $langcode
   *   The language code.
   * @param string $id
   *   The translation ID.
   *
   * @return \Drupal\babel\Model\StringTranslation|null
   *   The string object or NULL.
   */
  public function getString(string $langcode, string $id): ?StringTranslation;

  /**
   * Saves a translation.
   *
   * @param \Drupal\babel\Model\StringTranslation $string
   *   The object representing the translatable string.
   * @param string $id
   *   The string to be translated.
   * @param string $langcode
   *   The language code.
   * @param string $translation
   *   The translated string.
   */
  public function updateTranslation(StringTranslation $string, string $id, string $langcode, string $translation): void;

}
