<?php

declare(strict_types=1);

namespace Drupal\babel\Plugin\Babel;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Translation type plugin manager.
 */
class TranslationTypePluginManager extends DefaultPluginManager {

  /**
   * Instantiated plugins static cache.
   *
   * @var array<array-key, \Drupal\babel\Plugin\Babel\TranslationTypePluginInterface>
   */
  protected array $instances = [];

  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cacheBackend,
    ModuleHandlerInterface $moduleHandler,
    protected readonly ConfigFactoryInterface $configFactory,
  ) {
    parent::__construct('Plugin/Babel/TranslationType', $namespaces, $moduleHandler, TranslationTypePluginInterface::class, TranslationType::class);
    $this->alterInfo('babel_translation_type_info');
    $this->setCacheBackend($cacheBackend, 'babel_translation_type_info');
  }

  /**
   * {@inheritdoc}
   */
  public function createInstance($plugin_id, array $configuration = []): TranslationTypePluginInterface {
    if ($configuration) {
      // Normally we don't pass the plugin configuration because we solve it
      // here, see the few lines below. But if we do explicitly, we want a fresh
      // instantiation, so we reset the static cache.
      unset($this->instances[$plugin_id]);
    }

    if (!isset($this->instances[$plugin_id])) {
      $configuration = $configuration ?: $this->configFactory->get('babel.settings')->get("translation_type.plugin.$plugin_id") ?: [];
      $this->instances[$plugin_id] = parent::createInstance($plugin_id, $configuration);
    }
    return $this->instances[$plugin_id];
  }

  /**
   * {@inheritdoc}
   */
  public function clearCachedDefinitions(): void {
    $this->instances = [];
    parent::clearCachedDefinitions();
  }

}
