<?php

declare(strict_types=1);

namespace Drupal\Tests\babel\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\language\ConfigurableLanguageInterface;
use Drupal\language\Entity\ConfigurableLanguage;

/**
 * Base test class for Babel's kernel tests.
 */
class BabelKernelTestBase extends KernelTestBase {

  /**
   * Language code of the test language.
   *
   * @const string
   */
  protected const LANGCODE = 'pt';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['system', 'user'];

  /**
   * A configurable language to test with.
   *
   * @var \Drupal\language\ConfigurableLanguageInterface
   */
  protected ConfigurableLanguageInterface $language;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Not declaring in self::$modules because we need to run all install hooks.
    $installer = $this->container->get('module_installer');
    // In Drupal <11.2, we need to install 'language' first. It doesn't work to
    // run in the same install sequence.
    $installer->install(['language']);
    $installer->install(['babel']);

    $this->language = ConfigurableLanguage::createFromLangcode(static::LANGCODE);
    $this->language->save();
  }

}
