<?php

declare(strict_types=1);

namespace Drupal\Tests\babel\Traits;

use Drupal\babel\EventSubscriber\ConfigSubscriber;

/**
 * Trait for fully installing modules in Kernel tests.
 */
trait ModuleInstallHelperTrait {

  /**
   * Runs batches created as part of modules install.
   */
  protected function runInstallBatchOperations(): void {
    // Run batches if there are any.
    while ($batch = &batch_get()) {
      $batch['progressive'] = FALSE;
      batch_process();
    }

    \Drupal::service('string_translator.locale.lookup')->destruct();
    \Drupal::service(ConfigSubscriber::class)->destruct();
  }

}
