/**
 * @file
 * Handles copying source strings to translation form elements.
 */

(function (Drupal, once) {
  /**
   * Copies source string content to translation form elements.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches copy button click handlers to the translation form.
   */
  Drupal.behaviors.babelCopySource = {
    attach(context) {
      const copyButtons = once('babel-copy', '[data-babel-copy]', context);

      copyButtons.forEach(function (button) {
        button.addEventListener('click', function (e) {
          e.preventDefault();

          const hash = this.getAttribute('data-babel-copy');
          const row = document.querySelector(`[data-babel-row="${hash}"]`);

          if (!row) {
            return;
          }

          const sourceVariants = row.querySelectorAll(
            '[data-babel-source-variant]',
          );
          const translationVariants = row.querySelectorAll(
            '[data-babel-translation-variant]',
          );

          translationVariants.forEach(function (variant, index) {
            const textarea = variant.querySelector('textarea');
            if (textarea && !textarea.value) {
              const sourceIndex = index < sourceVariants.length ? index : 1;
              const sourceText =
                sourceVariants[sourceIndex].querySelector('textarea').value;
              textarea.value = sourceText;
              textarea.dispatchEvent(new Event('input', { bubbles: true }));
            }
          });
        });
      });
    },
  };
})(Drupal, once);
