<?php

declare(strict_types=1);

namespace Drupal\babel;

/**
 * Interface for strings repository service.
 */
interface BabelStringsRepositoryInterface {

  /**
   * Returns a list of strings sorted alphabetically by source string.
   *
   * @param string $langcode
   *   The results will contain existing translations in the requested language.
   * @param bool|null $translationStatus
   *   The translation status to filter for. NULL means no filtering. Optional,
   *   defaults to NULL.
   * @param string|null $search
   *   A string which should appear either in the source string or in the
   *   translation, if there is any. Optional, defaults to NULL which means no
   *   filtering. Check is case-insensitive.
   * @param bool|null $sourceStatus
   *   (optional) The status of the source string object to filter for. Defaults
   *   to NULL which means no filtering.
   *
   * @return array<array-key, \Drupal\babel\Model\StringTranslation>
   *   List of strings keyed by the source string hash and having string
   *   translation objects as values. The list is sorted by the source string.
   */
  public function getStrings(
    string $langcode,
    ?bool $translationStatus = NULL,
    ?string $search = NULL,
    ?bool $sourceStatus = NULL,
  ): array;

}
