<?php

declare(strict_types=1);

namespace Drupal\babel\Model;

/**
 * Object representing a translation.
 */
class Translation {

  public function __construct(
    public readonly string $language,
    public readonly string $string,
  ) {}

  /**
   * Returns an array representation of the class instance.
   *
   * @return array{language: string, string: string}
   *   An array representation of the class instance.
   */
  public function toArray(): array {
    return ['language' => $this->language, 'string' => $this->string];
  }

  /**
   * Restores a class instance out of a serialized array representation.
   *
   * @param array{language: string, string: string} $data
   *   An array representation of the class instance.
   *
   * @return $this
   */
  public static function fromArray(array $data): self {
    return new static($data['language'], $data['string']);
  }

}
