<?php

declare(strict_types=1);

namespace Drupal\Tests\babel\Kernel;

use Drupal\Tests\babel\Traits\ModuleInstallHelperTrait;

/**
 * Tests data integrity between babel_source_instance and babel_source tables.
 *
 * @group babel
 */
class BabelServiceDataIntegrityTest extends BabelKernelTestBase {

  use ModuleInstallHelperTrait;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->runInstallBatchOperations();
  }

  /**
   * Tests if babel tables have matching unique hashes.
   */
  public function testDataIntegrity(): void {
    $database = $this->container->get('database');

    // Count unique hashes in babel_source_instance.
    $sourceHashCount = $database->query(
      "SELECT COUNT(*) FROM (SELECT DISTINCT hash FROM {babel_source_instance}) AS wrapped"
    )->fetchField();

    // Count records in babel_source.
    $statusCount = $database->query(
      "SELECT COUNT(*) FROM {babel_source}"
    )->fetchField();

    $this->assertSame(
      $sourceHashCount,
      $statusCount,
      sprintf(
        'Data integrity check failed: babel_source_instance has %d unique hashes but babel_source has %d records',
        $sourceHashCount,
        $statusCount
      )
    );
  }

}
