# Babel

[![https://drupalcode.org/project/babel/badges/1.x/pipeline.svg](https://drupalcode.org/project/babel/badges/1.x/pipeline.svg)](https://drupalcode.org/project/babel)

## Description

Babel is an open-architecture module that enables the translation of all Drupal UI strings, whether they originate from code or configuration. Unlike the Locale module, Babel is not limited to configuration strings shipped with Drupal core or contributed modules; it exposes all strings through a unified interface.

### What is it trying to achieve?

Translators are typically non-technical users. Even if they can distinguish between interface translation and content translation, the concept of a string "coming from code" versus "coming from configuration" can be difficult to grasp. It may also be unclear why some configuration strings are available for translation while others are not. Additionally, finding the correct place to translate a string—such as one originating from a View—can be a challenge.

The Babel module aims to centralize all translatable strings, providing translators with a single point of access for their work.

### What it is not

* It doesn't store any translations. Babel only connects the dots, acting as a hub for different translation types: code strings, configuration strings. Because of its open architecture, Babel is able even to translate simple content entities such as menu link content, shortcut, or taxonomy terms.
* Babel doesn't communicate with [https://localize.drupal.org](https://localize.drupal.org). However, as it handles Locale module translations, it allows other modules to do so (e.g., `l10n_client`).

### Features

* A page where all UI source strings are available for translation, allowing a translator to quickly find and translate strings.
* Support for plural variants.
* File export/import. Exporters and importers are plugins, so a third-party module can easily add new plugins to extend the exported formats.

## Architecture

Babel doesn't store translations. It only brings together different translation types and exposes their source strings in a unified UI or in exported files. It does this using a plugin system that allows defining a plugin for each type of translation. Babel ships with two plugins that cover most Drupal UI translations: **Locale**, which bridges to the Locale module, and **Config**, which bridges to the configuration system. Additionally, the `babel_content_entity` submodule allows the translation of simple content entities such as menu link content, shortcut, or taxonomy terms. Even these entities are content, they appear as UI strings to a non-technical translator. Third-party modules can add their own plugins to handle the translation of other UI source strings.

Each translation-type plugin knows how to extract strings from its backend and how to save translated strings back. For instance, the Locale plugin reads the source and translated strings from the `locale` module tables and saves them in the same place. The Config plugin reads the strings from configuration objects and saves the translations to configuration storage. For content menu links, translations are stored in `menu_link_content`. Nothing is stored in the Babel module itself, either as a source or a translated strings.

A second type of plugin provided by the module is the **importer/exporter**. By using a plugin system, Babel allows the exported file format to be extended to any imaginable file type.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined and unified development process, is the recommended tool for contributing to the module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib) addon makes it easy to develop a Drupal module by offering tools to set up and test the module.

### Install DDEV

* Install a Docker provider by following the DDEV [Docker Installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/) instructions for your operating system.
* [Install DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/), using the documentation that best fits your OS.
* DDEV is used mostly via CLI commands. [Configure shell completion & autocomplete](https://ddev.readthedocs.io/en/stable/users/install/shell-completion/) according to your environment.
* Configure your IDE to take advantage of the DDEV features. This is a critical step for testing and debugging your module. Remember, the website runs inside Docker, so pay attention to these configurations:
  - [PhpStorm Setup](https://ddev.readthedocs.io/en/stable/users/install/phpstorm/)
  - [Configure](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/step-debugging/) PhpStorm and VS Code for step debugging.
  - Profiling with [xhprof](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xhprof-profiling/), [Xdebug](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xdebug-profiling/), and [Blackfire](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/blackfire-profiling/).

### Checkout the module

Normally, you check out the code from an [issue fork](https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/creating-issue-forks):

```shell
git clone git@git.drupal.org:issue/babel-[issue number].git
cd babel-[issue number]
```

### Start DDEV

Inside the cloned project, run:

```shell
ddev start
```

This command will start the Docker containers and apply all configurations.

### Install dependencies

```shell
ddev poser
```

This installs the PHP dependencies. Note that this is a replacement for the Composer _install_ command that knows how to bundle Drupal core with the module. Read more about this command at [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands).

```shell
ddev symlink-project
```

This symlinks the module inside `web/modules/custom`. Read more about this command at the same [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands) link.
Note: As soon as `vendor/autoload.php` is generated, this command runs automatically on every `ddev start`.

Run this command manually after adding new directories or files to the root of the module.

```shell
ddev exec "cd web/core && yarn install"
```

Installs Node.js dependencies. This is required for the `ddev eslint` command.

### Install Drupal

```shell
ddev install
```

This installs Drupal and enables the module.

### Changing the Drupal core and PHP versions

* Create a `.ddev/config.local.yaml` file.
* Set the desired Drupal core and PHP versions. For example:
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.5
  php_version: "8.1"
  ```
* Run `ddev restart`

### Run tests

* `ddev phpunit` — run PHPUnit tests
* `ddev phpcs` — run PHP coding standards checks
* `ddev phpcbf` — fix coding standards issues
* `ddev phpstan` — run PHP static analysis
* `ddev eslint` — run ESLint on JavaScript and YAML files
* `ddev stylelint` — run Stylelint on CSS files
