(function (Drupal) {
  /**
   * Build query string from parameters object.
   */
  function buildQueryString(params) {
    return Object.entries(params)
      .filter(([key, value]) => value !== '' && value != null)
      .map(
        ([key, value]) =>
          `${encodeURIComponent(key)}=${encodeURIComponent(value)}`,
      )
      .join('&');
  }

  /**
   * Check if a modal is currently open using Drupal's built-in methods.
   */
  function isModalOpen() {
    return !!(
      document.querySelector('.ui-dialog-content') ||
      document.querySelector('.ui-dialog') ||
      document.querySelector('[role="dialog"]') ||
      document.querySelector('[aria-modal="true"]')
    );
  }

  /**
   * AJAX command handler for pushParameters.
   *
   * This is a reusable command that can be used by any module
   * to update URL parameters via AJAX without page reload.
   */
  Drupal.AjaxCommands.prototype.pushParameters = function (
    ajax,
    response,
    status,
  ) {
    if (!window.history || !response.parameters) {
      return;
    }

    // Skip URL updates if we're in a modal context
    if (isModalOpen()) {
      return;
    }

    const queryString = buildQueryString(response.parameters);
    const url = `${window.location.pathname}${
      queryString ? `?${queryString}` : ''
    }`;

    window.history.pushState(response.parameters, document.title, url);
  };
})(Drupal);
