<?php

declare(strict_types=1);

namespace Drupal\babel_content_entity\Plugin\Babel;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Derives the 'content_entity' plugin over configured content entity types.
 */
class BabelContentEntityDeriver extends DeriverBase implements ContainerDeriverInterface {

  public function __construct(
    protected readonly ConfigFactoryInterface $configFactory,
    protected readonly EntityTypeManagerInterface $entityTypeManager,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id): self {
    return new static(
      $container->get('config.factory'),
      $container->get('entity_type.manager'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    $entityTypeIds = $this->configFactory->get('babel_content_entity.settings')->get('entity_type');
    $entityTypes = array_intersect_key($this->entityTypeManager->getDefinitions(), array_flip($entityTypeIds));

    foreach ($entityTypes as $entityTypeId => $entityType) {
      $this->derivatives[$entityTypeId] = $base_plugin_definition;
      $this->derivatives[$entityTypeId]['label'] = $entityType->getLabel();
    }

    return $this->derivatives;
  }

}
