<?php

declare(strict_types=1);

namespace Drupal\babel\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * AJAX command for updating browser URL parameters.
 */
class PushParametersCommand implements CommandInterface {

  /**
   * Constructs a PushParametersCommand object.
   *
   * @param array $parameters
   *   Key-value pairs of parameters to include in URL.
   */
  public function __construct(
    protected array $parameters = [],
  ) {}

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    return [
      'command' => 'pushParameters',
      'parameters' => $this->parameters,
    ];
  }

}
